package gui;

import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.ImageIcon;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.Font;
import java.awt.Color;
import java.awt.FlowLayout;
import net.miginfocom.swing.MigLayout;
import javax.swing.JComboBox;
import java.awt.Dimension;
import javax.swing.JTextField;
import javax.swing.JRadioButton;
import javax.swing.ButtonGroup;
import javax.swing.JSplitPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

public class MainAppWindow {

	private JFrame frmExpectingToFly;
	private JPanel northPanel;
	private JPanel westPanel;
	private JPanel eastPanel;
	private JPanel southPanel;
	private JPanel centerPanel;
	private JLabel lblExpectingToFly;
	private JButton btnStart;
	private JLabel lblSong;
	private JComboBox comboBoxSong;
	private JLabel lblAuthor;
	private JTextField textFieldAuthor;
	private JButton btnSave;
	private JRadioButton rdbtnBasic;
	private JRadioButton rdbtnIllustration;
	private JRadioButton rdbtnAll;
	private JLabel lblView;
	private final ButtonGroup buttonGroup = new ButtonGroup();
	private JSplitPane centerSplitPane;
	private JScrollPane rightScrollPane;
	private JScrollPane leftScrollPane;
	private JLabel lblIllusrtation;
	private JScrollPane leftScrollPane_1;
	private JTextArea lyricsTextArea;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					MainAppWindow window = new MainAppWindow();
					window.frmExpectingToFly.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public MainAppWindow() {
		initialize();
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frmExpectingToFly = new JFrame();
		frmExpectingToFly.setTitle("Expecting to Fly");
		frmExpectingToFly.setBounds(200, 100, 450, 300);
		frmExpectingToFly.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frmExpectingToFly.getContentPane().add(getNorthPanel(), BorderLayout.NORTH);
		frmExpectingToFly.getContentPane().add(getWestPanel(), BorderLayout.WEST);
		frmExpectingToFly.getContentPane().add(getEastPanel(), BorderLayout.EAST);
		frmExpectingToFly.getContentPane().add(getSouthPanel(), BorderLayout.SOUTH);
		frmExpectingToFly.getContentPane().add(getCenterPanel(), BorderLayout.CENTER);
	}
	private JPanel getNorthPanel() {
		if (northPanel == null) {
			northPanel = new JPanel();
			FlowLayout flowLayout = (FlowLayout) northPanel.getLayout();
			northPanel.add(getBtnStart());
			northPanel.add(getLblExpectingToFly());
		}
		return northPanel;
	}
	private JPanel getWestPanel() {
		if (westPanel == null) {
			westPanel = new JPanel();
			westPanel.setVisible(false);
			westPanel.setPreferredSize(new Dimension(150, 10));
			westPanel.setLayout(new MigLayout("", "[grow]", "[][]"));
			westPanel.add(getLblSong(), "cell 0 0");
			westPanel.add(getComboBox_1(), "cell 0 1,growx");
		}
		return westPanel;
	}
	private JPanel getEastPanel() {
		if (eastPanel == null) {
			eastPanel = new JPanel();
			eastPanel.setVisible(false);
			eastPanel.setPreferredSize(new Dimension(100, 10));
			eastPanel.setLayout(new MigLayout("", "[grow]", "[][][grow][]"));
			eastPanel.add(getLblAuthor(), "cell 0 0");
			eastPanel.add(getTextFieldAuthor(), "cell 0 1,growx");
			eastPanel.add(getBtnSave(), "cell 0 3,alignx right");
		}
		return eastPanel;
	}
	private JPanel getSouthPanel() {
		if (southPanel == null) {
			southPanel = new JPanel();
			southPanel.setVisible(false);
			southPanel.setLayout(new MigLayout("", "[grow][][][][grow]", "[][]"));
			southPanel.add(getLblView(), "cell 1 0 3 1,alignx center");
			southPanel.add(getRdbtnBasic(), "cell 1 1");
			southPanel.add(getRdbtnIllustration(), "cell 2 1");
			southPanel.add(getRdbtnAll(), "cell 3 1");
		}
		return southPanel;
	}
	private JPanel getCenterPanel() {
		if (centerPanel == null) {
			centerPanel = new JPanel();
			centerPanel.setVisible(false);
			centerPanel.setLayout(new MigLayout("", "[grow]", "[grow]"));
			centerPanel.add(getCenterSplitPane(), "cell 0 0,grow");
		}
		return centerPanel;
	}
	private JLabel getLblExpectingToFly() {
		if (lblExpectingToFly == null) {
			lblExpectingToFly = new JLabel("Expecting to Fly");
			lblExpectingToFly.setVisible(false);
			lblExpectingToFly.setForeground(Color.BLUE);
			lblExpectingToFly.setFont(new Font("Tahoma", Font.BOLD, 16));
		}
		return lblExpectingToFly;
	}
	private JButton getBtnStart() {
		if (btnStart == null) {
			btnStart = new JButton("Start");
			btnStart.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					btnStart.setVisible(false);
					getLblExpectingToFly().setVisible(true);
					getCenterPanel().setVisible(true);
					getEastPanel().setVisible(true);
					getSouthPanel().setVisible(true);
					getWestPanel().setVisible(true);
					rdbtnIllustration.setSelected(true);
				}
			});
		}
		return btnStart;
	}
	private JLabel getLblSong() {
		if (lblSong == null) {
			lblSong = new JLabel("Song");
		}
		return lblSong;
	}
	private JComboBox getComboBox_1() {
		if (comboBoxSong == null) {
			comboBoxSong = new JComboBox();
			comboBoxSong.addItem("Expecting to Fly");
			comboBoxSong.addItem("California Dreaming");
			comboBoxSong.addItem("Rainy Day Women");
			comboBoxSong.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent arg0) {
					if (arg0.getStateChange() == ItemEvent.SELECTED) {
						System.out.println("Selected");
					}
				}
			});
		}
		return comboBoxSong;
	}
	private JLabel getLblAuthor() {
		if (lblAuthor == null) {
			lblAuthor = new JLabel("Author");
		}
		return lblAuthor;
	}
	private JTextField getTextFieldAuthor() {
		if (textFieldAuthor == null) {
			textFieldAuthor = new JTextField();
			textFieldAuthor.setColumns(10);
		}
		return textFieldAuthor;
	}
	private JButton getBtnSave() {
		if (btnSave == null) {
			btnSave = new JButton("Save");
			btnSave.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					System.out.println("Something");
				}
			});
		}
		return btnSave;
	}
	private JRadioButton getRdbtnBasic() {
		if (rdbtnBasic == null) {
			rdbtnBasic = new JRadioButton("Basic");
			rdbtnBasic.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent arg0) {
					if (arg0.getStateChange() == ItemEvent.SELECTED) {
						getWestPanel().setVisible(true);
						getEastPanel().setVisible(true);
						getLblAuthor().setVisible(false);
						getTextFieldAuthor().setVisible(false);
						getBtnSave().setVisible(false);
						getCenterPanel().setVisible(false);
					}
				}
			});
			buttonGroup.add(rdbtnBasic);
		}
		return rdbtnBasic;
	}
	private JRadioButton getRdbtnIllustration() {
		if (rdbtnIllustration == null) {
			rdbtnIllustration = new JRadioButton("Illustration");
			rdbtnIllustration.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					if (e.getStateChange() == ItemEvent.SELECTED) {
						getWestPanel().setVisible(true);
						getEastPanel().setVisible(true);
						getLblAuthor().setVisible(false);
						getTextFieldAuthor().setVisible(false);
						getBtnSave().setVisible(false);
						getCenterPanel().setVisible(true);
					}
				}
			});
			buttonGroup.add(rdbtnIllustration);
		}
		return rdbtnIllustration;
	}
	private JRadioButton getRdbtnAll() {
		if (rdbtnAll == null) {
			rdbtnAll = new JRadioButton("All");
			rdbtnAll.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					if (e.getStateChange() == ItemEvent.SELECTED) {
						getWestPanel().setVisible(true);
						getEastPanel().setVisible(true);
						getLblAuthor().setVisible(true);
						getTextFieldAuthor().setVisible(true);
						getBtnSave().setVisible(true);
						getCenterPanel().setVisible(true);
					}
				}
			});
			buttonGroup.add(rdbtnAll);
		}
		return rdbtnAll;
	}
	private JLabel getLblView() {
		if (lblView == null) {
			lblView = new JLabel("View");
		}
		return lblView;
	}
	private JSplitPane getCenterSplitPane() {
		if (centerSplitPane == null) {
			centerSplitPane = new JSplitPane();
			centerSplitPane.setDividerLocation(50);
			centerSplitPane.setOneTouchExpandable(true);
			centerSplitPane.setRightComponent(getRightScrollPane());
			centerSplitPane.setLeftComponent(getLeftScrollPane());
		}
		return centerSplitPane;
	}
	private JScrollPane getRightScrollPane() {
		if (rightScrollPane == null) {
			rightScrollPane = new JScrollPane();
			rightScrollPane.setViewportView(getLblIllusrtation());
		}
		return rightScrollPane;
	}
	private JScrollPane getLeftScrollPane() {
		if (leftScrollPane == null) {
			leftScrollPane = new JScrollPane();
			leftScrollPane.setViewportView(getLeftScrollPane_1());
		}
		return leftScrollPane;
	}
	private JLabel getLblIllusrtation() {
		if (lblIllusrtation == null) {
			lblIllusrtation = new JLabel("");
			lblIllusrtation.setIcon(new ImageIcon("C:\\Documents and Settings\\student1.SLUSAONICA-C001.002\\My Documents\\Expecting to Fly E\\Neil Young.jpg"));
		}
		return lblIllusrtation;
	}
	private JScrollPane getLeftScrollPane_1() {
		if (leftScrollPane_1 == null) {
			leftScrollPane_1 = new JScrollPane();
			leftScrollPane_1.setViewportView(getLyricsTextArea());
		}
		return leftScrollPane_1;
	}
	private JTextArea getLyricsTextArea() {
		if (lyricsTextArea == null) {
			lyricsTextArea = new JTextArea();
		}
		return lyricsTextArea;
	}
}
